﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.ComponentModel;

namespace PsgBase
{
    public class psgCheckBox : CheckBox
    {
        #region Fields / Contructors

        public bool initial_value = false;
        string valueKey = string.Empty;
        string fieldKey = string.Empty;
        string fieldName = string.Empty;
        string servertablename = string.Empty;
        string fieldType;
        bool notNull;
        DataTable table;
        int hmn_loop;
        string text = string.Empty;
        int intl;

        public void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // psgCheck
            // 
            this.Validated += new System.EventHandler(this.edtext_Validated);
            this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.psgedit_KeyPress);
            this.Enter += new System.EventHandler(this.psgedit_Enter);
            this.ResumeLayout(false);

        }

        public psgCheckBox()
        {
            InitializeComponent();
        }

        #endregion

        #region Properties

        [Category("PSG")]
        public string PsgFieldType
        {
            get { return fieldType; }
            set { fieldType = value; }
        }

        [Category("PSG")]
        public bool PsgNotNull
        {
            get { return notNull; }
            set { notNull = value; }
        }

        [Category("PSG")]
        public string PsgFieldName
        {
            get { return fieldName; }
            set
            {
                fieldName = value;
            }
        }

        [Category("PSG")]
        public int PsgIntl
        {
            get { return intl; }
            set { intl = value; }
        }

        [Browsable(false)]
        public DataTable Table
        {
            get { return table; }
            set { table = value; }
        }

        [Category("PSG"), Browsable(false)]
        public string PsgValueKey
        {
            get { return valueKey; }
            set { valueKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return servertablename; }
            set { servertablename = value; }
        }

        [Browsable(false)]
        public string LabelIntl
        {
            get
            {
                if (this.DesignMode)
                    return this.text;

                if (Base.tableIntl == null || Base.tableIntl.Rows.Count == 0)
                    return this.text;

                return Base.GetIntl(this.PsgIntl, this.text);
            }
        }

        public override string Text
        {
            get
            {
                return this.LabelIntl;
            }
            set
            {
                this.text = value;
            }
        }

        #endregion

        private void psgedit_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == Convert.ToChar(13))
            {
                if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                     string.IsNullOrEmpty(this.PsgFieldKey) ||
                     string.IsNullOrEmpty(this.PsgFieldName) ||
                     string.IsNullOrEmpty(this.PsgFieldType))
                {
                    MessageBox.Show("PSG properties are not set. ", "Attention!");
                    return;
                }

                psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName));
                Base.bUpdate = false;
                SendKeys.Send("{TAB}");
                e.Handled = true;
            }
        }

        private void edtext_Validated(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                 string.IsNullOrEmpty(this.PsgFieldKey) ||
                 string.IsNullOrEmpty(this.PsgFieldName) ||
                 string.IsNullOrEmpty(this.PsgFieldType))
            {
                MessageBox.Show("PSG properties are not set. ", "Attention!");
                return;
            }

            psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName));
        }
        public void psgUpdate(object sender, string _id)
        {
            if ( (((psgCheckBox)sender).Checked && !this.initial_value) ||  (!((psgCheckBox)sender).Checked && this.initial_value))
            {
                Base.kv = Base.GetParameters(_id, "C");
                if (fieldType.ToLower() == "i")
                    Base.value = Base.GetParameters(Convert.ToInt16(this.Checked), fieldType);
                else
                    Base.value = Base.GetParameters(this.Checked, fieldType);
                Base.psgIntf.send_command("UPDATEFIELD#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                    + "'," + Base.kv + ",'" + this.PsgFieldName + "'," + Base.value);

                CheckUpdate();
            }
        }
        public void CheckUpdate()
        {
            hmn_loop = 0;
            while (Intf.cmdResult != PsgMsg.OK && this.hmn_loop <= 200)
            {
                Thread.Sleep(30);
                this.hmn_loop = this.hmn_loop + 1;
            }

            if (Intf.cmdResult == PsgMsg.NOK)
            {
                MessageBox.Show("Server communication failed. Check server connectivity and try again!", "Attention!", MessageBoxButtons.OK);
                this.Checked = this.initial_value;
            }

            this.initial_value = this.Checked;

            View view = ((Base)this.FindForm()).view;
            if (view != null && view is ViewGrid && view.bsEditor != null)
                view.bsEditor.EndEdit();
        }

        void psgedit_Enter(object sender, EventArgs e)
        {
            this.initial_value = this.Checked;
            Base.bUpdate = true;
        }
    }
}
